const googleTranslateConfig = {
    lang: "ru",
    autoDisplay: false
};

function setCookie(name, value, options) {options = options || {};var expires = options.expires;if (typeof expires == "number" && expires) {var d = new Date();d.setTime(d.getTime() + expires * 1000);expires = options.expires = d;}if (expires && expires.toUTCString) {options.expires = expires.toUTCString();}value = encodeURIComponent(value);var updatedCookie = name + "=" + value;for (var propName in options) {updatedCookie += "; " + propName;var propValue = options[propName];if (propValue !== true) {updatedCookie += "=" + propValue;}}document.cookie = updatedCookie;}
function getCookie(name){var matches = document.cookie.match(new RegExp("(?:^|; )" + name.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g, '\\$1') + "=([^;]*)"));return matches ? decodeURIComponent(matches[1]) : undefined;}
function deleteCookie(name) {setCookie(name, "", {expires: -1});}

function TranslateInit() {

    if (googleTranslateConfig.langFirstVisit && !getCookie('googtrans')) {
        // Если установлен язык перевода для первого посещения и куки не назначены
        TranslateCookieHandler("/auto/" + googleTranslateConfig.langFirstVisit);
    }

    let code = TranslateGetCode();
    if ($('[data-lang="' + code + '"]') !== null) {
        $('[data-lang="' + code + '"]').addClass('lang-sel');
    }

    if (code == googleTranslateConfig.lang) {
        // Если язык по умолчанию, совпадает с языком на который переводим
        // То очищаем куки
        TranslateCookieHandler(null, googleTranslateConfig.domain);
    }

    // Инициализируем виджет с языком по умолчанию
    new google.translate.TranslateElement({
        pageLanguage: googleTranslateConfig.lang,
    });

}

function changeLang(lang) {
    TranslateCookieHandler("/" + googleTranslateConfig.lang + "/" + lang, googleTranslateConfig.domain);
    // Перезагружаем страницу
    window.location.reload();
}

function TranslateGetCode() {
    // Если куки нет, то передаем дефолтный язык
    let lang = (getCookie('googtrans') != undefined && getCookie('googtrans') != "null") ? getCookie('googtrans') : googleTranslateConfig.lang;
    return lang.match(/(?!^\/)[^\/]*$/gm)[0];
}

function TranslateCookieHandler(val, domain) {
    // Записываем куки /язык_который_переводим/язык_на_который_переводим
    setCookie('googtrans', val);
    setCookie("googtrans", val, {
        domain: "." + document.domain,
    });

    if (domain == "undefined") return;
    // записываем куки для домена, если он назначен в конфиге
    setCookie("googtrans", val, {
        domain: domain,
    });

    setCookie("googtrans", val, {
        domain: "." + domain,
    });
}