<?php
final class MySQL {
  private $link;
  private $numMySQL;

  public function __construct() {
    
    global $config;
    
    $this->numMySQL = 0;
    $this->link = mysqli_connect($config["mysql_host"], $config["mysql_user"], $config["mysql_pass"], $config["mysql_bd"]);
    if (mysqli_connect_errno($this->link)) {
      trigger_error("Нет соединения с MySQL");
    }

    mysqli_set_charset($this->link, $config["mysql_charset"]);
    
  }

  public function query($sql) {
    $this->numMySQL++;
    $resource = mysqli_query($this->link,$sql);
    if($resource){
	  if (is_object($resource)) {

        $i = 0;

		$data = array();

		while ($result = mysqli_fetch_assoc($resource)) {
		  $data[$i] = $result;
    	  $i++;
		}

        mysqli_free_result($resource);

		$query = new stdClass();
		$query->row = isset($data[0]) ? $data[0] : array();
		$query->rows = $data;
		$query->num_rows = $i;

		unset($data);
		return $query;

      }else{
        $query = new stdClass();
	    $query->row = array();
	    $query->rows = array();
	    $query->num_rows = 0;
	  
	    return $query;
      }
	}else{
		$query = new stdClass();
	  $query->row = array();
	  $query->rows = array();
	  $query->num_rows = 0;
	  
	  return $query;
	}
    mysqli_close($this->link);
  }

  public function escape($value) {
    return mysqli_real_escape_string($this->link, $value);
  }

  public function insert_id() {
    return mysqli_insert_id($this->link);
  }

  public function numMySQL() {
    return $this->numMySQL;
  }
}

?>