<?php

function yoomoney_balance()
{
    global $setup_payment;
    $client = new \GuzzleHttp\Client([]);
    try {
        $res = $client->request('POST', 'https://yoomoney.ru/api/account-info', [
            'form_params' => [],
            'headers' => [
                'Authorization' => 'Bearer '.$setup_payment['yoomoney_access_token']
            ]
        ]);
        $res = json_decode($res->getBody()->getContents(), true);
        return $res['balance'];
    }
    catch(\GuzzleHttp\Exception\ConnectException $e) {
        return 'Ошибка подключения к yoomoney';
    }
    catch(\GuzzleHttp\Exception\ClientException $e) {
        return 'Неверные данные авторизации';
    }
}

function yoomoney_request_p2p($wallet, $money, $comment = '')
{
    global $setup_payment;
    $money = moneyformat($money);
    $client = new \GuzzleHttp\Client([]);
    try {
        $res = $client->request('POST', 'https://yoomoney.ru/api/request-payment', [
            'form_params' => [
                'pattern_id' => 'p2p',
                'to' => $wallet,
                'amount_due' => $money,
                'comment' => $comment,
                'message' => $comment
            ],
            'headers' => [
                'Authorization' => 'Bearer '.$setup_payment['yoomoney_access_token']
            ]
        ]);
    }
    catch(Exception $e) {
        writeLog('yoomoney_request_p2p: '.$e->getMessage(), 'payout.log');
        return false;
    }
    $r = json_decode($res->getBody()->getContents(), true);
    if($r['status'] != 'success')
    {
        writeLog('yoomoney_request_p2p: '.json_encode($r), 'payout.log');
        return false;
    }
    return $r;
}

function yoomoney_process_p2p($request_id, $money_source)
{
    global $setup_payment;
    $client = new \GuzzleHttp\Client([]);
    try {
        $res = $client->request('POST', 'https://yoomoney.ru/api/process-payment', [
            'form_params' => [
                'request_id' => $request_id,
                'money_source' => $money_source
            ],
            'headers' => [
                'Authorization' => 'Bearer '.$setup_payment['yoomoney_access_token']
            ]
        ]);
    }
    catch(Exception $e) {
        writeLog('yoomoney_process_p2p: '.$e->getMessage(), 'payout.log');
        return false;
    }
    $r = json_decode($res->getBody()->getContents(), true);
    if($r['status'] != 'success') {
        writeLog('yoomoney_process_p2p: '.json_encode($r), 'payout.log');
        return false;
    }
    return true;
}