<?php
final class classVK {
	
  private $client_id = 'a8c07ff4'; //uLogin ID (https://ulogin.ru/lk.php) p
  private $key = '3b24f63a3b24f63a3b24f63ac03b54344c33b243b24f63a65a36e0bfeb212a11022fb49'; //Сервисный ключ доступа ВК приложение
  private $host; //Хост
  private $users_likes = false; //Статус проверки лайков
  private $users_repost = false; //Статус проверки репоста группы
  private $count = 50;  //Смещение при проверке (max 100)
  private $max_count = 600;  //Максимальное смещение по стене
  private $charset = 'UTF-8'; //Кодировка
  private $verVK = '5.131'; //Версия API
  private $pregURL = '/(.*)=(photo||wall||video)([\-0-9]*)_([0-9]*)([^A-Za-z0-9])?/'; //Регулярка для парсинга ссылок
  
  //Ссылка на информацию о пользователе
  private $linkInfaUser = 'http://ulogin.ru/token.php';
  
  //Ссылка на информацию о друзьях
  private $linkInfaFriends = 'https://api.vk.com/method/friends.get';
  
  //Ссылка на информацию о сообществе
  private $linkGroups = 'https://api.vk.com/method/groups.getById';
  
  //Ссылка на информацию о лайках и репостах (фото, стена, видео)
  private $linkLikes = 'https://api.vk.com/method/likes.getList';
  
  //Ссылка проверки вступления в сообщество
  private $linkStatusGroups = 'https://api.vk.com/method/groups.isMember';
  
  //Ссылка проверки стены пользователя
  private $linkStatusRePost = 'https://api.vk.com/method/wall.get';
  
  
  public function __construct() {
    $this->host = $_SERVER['HTTP_HOST'];
  }

  private function CharSetVK($data){
   
    if($this->charset != 'UTF-8'){
	  
	  if (is_array($data) || is_object($data)){
        foreach ($data as &$val){
          $val= $this->CharSetVK($val);
        }
        return $data;
      }else{
        return iconv('UTF-8', $this->charset, $data);
      }

	}else{
	  return $data;	
	} 

  }
  
  //Формирование Кнопки uLogin
  public function linkSiteVK($name, $func)
  {
    $button = '
      <div id="uLogin_vk" data-ulogin="display=panel;theme=classic;fields=first_name,last_name;providers=vkontakte;hidden=;callback='.$func.';mobilebuttons=0;"></div>
    ';
    // $button = '
    //   <div id="uLogin" data-network="vk" data-ulogin="display=buttons;fields=first_name,last_name,email;callback='.$func.';">
    //     <div data-uloginbutton="vkontakte">'.$name.'</div>
    //   </div>
    // ';

    return $button;
  }
  
  //Информация о пользователе
  public function infaUserVK($token) {
    
    $new_infa = array();
    
    $params = array(
      'token'        => $token,
      'host'         => $this->host
    );
    
    $infa_user = @file_get_contents( $this->linkInfaUser  . '?' . urldecode(http_build_query($params)) );
    $infa_user = $this->CharSetVK(json_decode($infa_user,true));
    
    if(is_array($infa_user)){
      
      if(!isset($infa_user['uid'])) return false;
      
      $new_infa['id'] = $infa_user['uid'];
      $new_infa['first_name'] = $infa_user['first_name'];
      $new_infa['last_name'] = $infa_user['last_name'];
      $new_infa['domain'] = $infa_user['profile'];
      $new_infa['email'] = (isset($infa_user['email'])) ? $infa_user['email'] : '';
      
      return $new_infa;
      
    }else{
	  return false;
	}	
  }
  
  //Информация о друзьях
  public function infaFriends($user_id) {
  
    $params = array(
      'user_id'         => $user_id,
      'count'           => '1',
      'access_token'    => $this->key,
      'v'               => $this->verVK
    );
    
    $infa_friends = @file_get_contents( $this->linkInfaFriends  . '?' . urldecode(http_build_query($params)) );
    $infa_friends = $this->CharSetVK(json_decode($infa_friends,true));
    
    if(is_array($infa_friends)){
      
      if(!isset($infa_friends['response'])) return 0;
      
      return $infa_friends['response']['count'];
      
    }else{
	  return 0;
	}	
	
  }
  
  //Информация о сообществе
  public function infaGroups($group_id) {
    
    $new_infa = array();
    
    $params = array(
      'group_id'        => $group_id,
      'access_token'    => $this->key,
      'v'               => $this->verVK
    );
    
    $infa_groups = @file_get_contents( $this->linkGroups  . '?' . urldecode(http_build_query($params)) );
    $infa_groups = $this->CharSetVK(json_decode($infa_groups,true));
    
    if(is_array($infa_groups)){
      
      if(!isset($infa_groups['response'][0]['id'])) return false;
      
      $new_infa['id'] = $infa_groups['response'][0]['id'];
      $new_infa['screen_name'] = $infa_groups['response'][0]['screen_name'];
      $new_infa['title'] = $infa_groups['response'][0]['name'];
      $new_infa['is_closed'] = $infa_groups['response'][0]['is_closed'];
      $new_infa['type'] = 'groups';
      
      return $new_infa;
      
    }else{
	  return false;
	}	
  }
  
  //Информация о вступление в сообщество
  public function infaStatusGroups($group_id, $users_id) {
    
    $params = array(
      'user_id'         => $users_id,
      'group_id'        => $group_id,
      'access_token'    => $this->key,
      'v'               => $this->verVK
    );
    
    $infa_status_groups = @file_get_contents( $this->linkStatusGroups  . '?' . urldecode(http_build_query($params)) );
    $infa_status_groups = $this->CharSetVK(json_decode($infa_status_groups,true));
    
    if(is_array($infa_status_groups)){
      
      if(!isset($infa_status_groups['response'])) return false;
      
      $new_infa = ($infa_status_groups['response'] == 1)? true : false ;
      
      return $new_infa;
      
    }else{
	  return false;
	}	
  }
  
  //Проверка на существование (фото, видео и запись)
  public function infaArea($url_vk) {

    $new_infa = array();
    
    $data_url = parse_url ($url_vk);
    if (!isset($data_url['query'])) return false;
    preg_match($this->pregURL, $data_url['query'], $data);

    switch($data[2]){
		case 'photo': $type = 'photo'; break;
		case 'wall': $type = 'post'; break;
		case 'video': $type = 'video'; break;
		default: return false; break;
	}
	
    if(!isset($data[3]) or !isset($data[4])) return false;

    $params = array(
      'type'            => $type,
      'owner_id'        => $data[3],
      'item_id'         => $data[4],
      'filter'          => 'likes',
      'count'           => '1',
      'access_token'    => $this->key,
      'v'               => $this->verVK
    );

    $infa_status = @file_get_contents( $this->linkLikes  . '?' . urldecode(http_build_query($params)) );
    $infa_status = $this->CharSetVK(json_decode($infa_status,true));
    
    if(is_array($infa_status)){
      
      if(!isset($infa_status['response'])) return false;
      
      $new_infa['type'] = trim($type);
      $new_infa['owner_id'] = trim($data[3]);
      $new_infa['item_id'] = trim($data[4]);
      
      return $new_infa;
      
    }else{
	  return false;
	}
		
  }
  
  //Проверка всех пользователей у объекта (фото, видео и запись)
  private function GetStatusLikes($owner_id, $item_id, $users_id, $type, $filter, $offset = 0) {			
		
    $params = array(
      'type'            => $type,
      'offset'          => $offset,
      'count'           => $this->count,
      'owner_id'        => $owner_id,
      'item_id'         => $item_id,
      'filter'          => $filter,
      'access_token'    => $this->key,
      'v'               => $this->verVK
    );
    
    $infa_likes = @file_get_contents( $this->linkLikes  . '?' . urldecode(http_build_query($params)) );
//	 $handler = fopen($_SERVER['DOCUMENT_ROOT'].'/logs/logvk.txt',"a+");
//    fwrite($handler, $infa_likes.'
    
//    ');
//    fclose($handler);
    $infa_likes = $this->CharSetVK(json_decode($infa_likes,true));

    if(is_array($infa_likes)){
      
      if (!isset($infa_likes['response'])) return false;
	  
	  $users = $infa_likes['response']['items'];
	  
	  if (count($users) == 0) return false;
			
	  if(in_array($users_id, $users)){ return $this->users_likes = true; }

	  $offset += $this->count;
			
	  $this->GetStatusLikes($owner_id, $item_id, $users_id, $type, $filter, $offset);
	
	}else{
	  return false;
	}		
  
  }
  
  //Проверка статуса лайка или репоста (фото, видео и запись)
  public function infaStatusLikes($owner_id, $item_id, $users_id, $type, $filter) {			
	
	$this->GetStatusLikes($owner_id, $item_id, $users_id, $type, $filter);	
    
    $status_likes = $this->users_likes;
    $this->users_likes = false;
    
    return $status_likes;
	
  }
  
  //Проверка всех записей на стене пользователя
  private function GetStatusRePost($owner_id, $groups_id, $offset = 0) {			
		
    $params = array(
      'offset'          => $offset,
      'count'           => $this->count,
      'owner_id'        => $owner_id,
      'filter'          => 'owner',
      'access_token'    => $this->key,
      'v'               => $this->verVK
    );
    
    $infa_repost = @file_get_contents( $this->linkStatusRePost  . '?' . urldecode(http_build_query($params)) );
    $infa_repost = $this->CharSetVK(json_decode($infa_repost,true));

    if(@is_array($infa_repost['response']))
    {
      if (!isset($infa_repost['response']['items'])) return false;
	  
  	  $items = $infa_repost['response']['items'];
  	  
  	  if (count($items) == 0) return false;
  			
  	  $wall_infa = array();
  	  
  	  foreach($items as $val){
        if (!isset($val['copy_history'])) continue;
        $wall_infa[$val['copy_history'][0]['owner_id']] = $val['copy_history'][0]['owner_id'];
      }

  	  if(array_key_exists($groups_id, $wall_infa)) {
        return $this->users_repost = true;
      }

  	  unset($wall_infa);
  	  
  	  if($this->max_count <= $offset) return false;
  	  
  	  $offset += $this->count;
  			
  	  $this->GetStatusRePost($owner_id, $groups_id, $offset);  
  	
  	}
    else
  	  return false;
  }
  
  //Проверка статуса репоста группы
  public function infaStatusRePost($owner_id, $groups_id) {
	
	  $this->GetStatusRePost($owner_id, $groups_id);
    
    $status_repost = $this->users_repost;
    $this->users_repost = false;
    
    return $status_repost;
	
  }
  
  
  
}