<?php

final class MySQL {
  private $link;
  private $numMySQL;

  public function __construct() {
    
    global $setup_web;
    
    $arr_host = explode(',', $setup_web['mysql_host']);
    $bd_host = (count($arr_host) > 1)? $arr_host[mt_rand(0, count($arr_host)-1)] : $arr_host[0];

    $this->numMySQL = 0;
    $this->link = mysqli_connect($bd_host, $setup_web['mysql_user'], $setup_web['mysql_pass'], $setup_web['mysql_bd']);
    if (mysqli_connect_errno()) {
      trigger_error("Нет соединения с MySQL");
    }

if (!mysqli_ping($this->link)) {
      $bd_host = (count($arr_host) > 1)? $arr_host[mt_rand(0, count($arr_host)-1)] : $arr_host[0] ;
      $this->link = mysqli_connect($bd_host, $setup_web['mysql_user'], $setup_web['mysql_pass'], $setup_web['mysql_bd']);
    }   
  
    mysqli_set_charset($this->link, 'UTF8');
    
  }

  public function get_insertid()
  {
    return mysqli_insert_id($this->link);
  }

  public function begin_transaction()
  {
    return mysqli_begin_transaction($this->link);
  }

  public function commit()
  {
    return mysqli_commit($this->link);
  }

  public function _log($sql)
  {
    writeLog($_SERVER['REQUEST_URI']."\nMysql error: ".mysqli_error($this->link).' ('.mysqli_errno($this->link).")\nQuery: ".$sql, 'mysql.log', true);
  }

  public function query($sql, $params = []) {
    $this->numMySQL++;

    $stmt = mysqli_prepare($this->link, $sql);
    if ($stmt === false)
      $this->_log($sql);

    if (count($params) > 0)
    {
      $types = '';
      foreach ($params as $param)
        if (gettype($param) == 'string')
          $types .= 's';
        elseif (gettype($param) == 'integer')
          $types .= 'i';
        elseif (gettype($param) == 'double')
          $types .= 'd';
      mysqli_stmt_bind_param($stmt, $types, ...$params);
    }
    mysqli_stmt_execute($stmt);
    $resource = mysqli_stmt_get_result($stmt);
    mysqli_stmt_close($stmt);

    // $resource = mysqli_query($this->link, $sql);
    if ($resource)
    {
      if (is_object($resource))
      {
        $i = 0;
        $data = array();
        while ($result = mysqli_fetch_assoc($resource)) {
          $data[$i] = $result;
            $i++;
        }
        mysqli_free_result($resource);
        $query = new stdClass();
        $query->row = isset($data[0]) ? $data[0] : array();
        $query->rows = $data;
        $query->num_rows = $i;
        unset($data);
        return $query;
      }
      else
      {
        $query = new stdClass();
        $query->row = array();
        $query->rows = array();
        $query->num_rows = 0;
        return $query;
      }
    }
    else
    {
      $errno = mysqli_errno($this->link);
      if ($errno != 0)
        writeLog($_SERVER['REQUEST_URI']."\nMysql error: ".mysqli_error($this->link).' ('.$errno.")\nQuery: ".$sql, 'mysql.log', true);
      $query = new stdClass();
      $query->row = array();
      $query->rows = array();
      $query->num_rows = 0;
      return $query;
    }
    mysqli_close($this->link);
  }

  public function escape($value) {
    return mysqli_real_escape_string($this->link, $value);
  }

  public function insert_id() {
    return mysqli_insert_id($this->link);
  }

  public function numMySQL() {
    return $this->numMySQL;
  }
}