<?php

ini_set('display_startup_errors', 1);
ini_set('display_errors', 0); // 0 - выключить показ ошибок
// error_reporting(-1);

function handler_error($errno, $errstr, $errfile, $errline)
{
  if ($errno != 8192)
  {
    writeLog("Уровень ошибки: $errno\nОшибка: $errstr\nФайл: $errfile\nСтрока: $errline\nURL: $_SERVER[REQUEST_URI]", 'error.log', true);
    exit('Ошибка');
  }
}

set_error_handler('handler_error');

function fatal_handler()
{
    $errfile = 'unknown file';
    $errstr  = 'shutdown';
    $errno   = E_CORE_ERROR;
    $errline = 0;

    $error = error_get_last();

    if ($error !== NULL)
    {
        $errno   = $error['type'];
        $errfile = $error['file'];
        $errline = $error['line'];
        $errstr  = $error['message'];

        if ($errno != 8192)
        {
          handler_error($errno, $errstr, $errfile, $errline);
          exit('Ошибка');
        }
    }
}

register_shutdown_function('fatal_handler');

mb_internal_encoding('UTF-8');

require $_SERVER['DOCUMENT_ROOT'].'/vendor/autoload.php';

require $_SERVER['DOCUMENT_ROOT'].'/config/setup.web.php';
require $_SERVER['DOCUMENT_ROOT'].'/config/setup.other.php';

define('DEBUG', true);
define('DOMAIN', $setup_web['domain']);
define('PROTOCOL', isset($_SERVER['HTTPS']) ? 'https' : 'http');
define('BASEURL', PROTOCOL.'://'.$setup_web['domain']);
define('PATCH_SCRIN', $_SERVER['DOCUMENT_ROOT'].'/scrinsupport');

function writeLog($text, $file = 'error.log', $dop = false)
{
    if ($dop)
      $d = "\n";
    else
      $d = "\n\n";
    file_put_contents($_SERVER['DOCUMENT_ROOT']."/logs/$file", '['.date('d/m/Y H:i:s').' '.$_SERVER['REMOTE_ADDR']."]\n".$text.$d, FILE_APPEND);
    if ($dop)
        file_put_contents($_SERVER['DOCUMENT_ROOT']."/logs/$file", "Get:'".json_encode($_GET, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES)."'\nPost:'".json_encode($_POST, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES)."'\n\n", FILE_APPEND);
}

//Старт сессии
function startSession()
{
  if (session_id())
    return true;
  else
  {
    $r = session_start([
      'save_path' => $_SERVER['DOCUMENT_ROOT'].'/sessions',
      'cookie_lifetime' => 86400*7,
      'gc_maxlifetime' => 86400*7
    ]);
    if (!$r)
      exit('Session start error');
    return $r;
  }
}

function sql_text($text){
  $text = strip_tags($text);
  $text = stripslashes ($text);
  $text = str_replace("~"," ",$text);
  $text = htmlspecialchars($text, ENT_QUOTES, 'UTF-8');
  $text = str_replace(",","&sbquo;",$text);
  return $text;
}

function ucfirst_utf8($str)
{
    return mb_substr(mb_strtoupper($str, 'utf-8'), 0, 1, 'utf-8') . mb_substr($str, 1, mb_strlen($str)-1, 'utf-8');
}

//Обработка логина
function load_username($username){  
  $username = trim($username);
  $username = mb_strtolower($username, 'UTF-8');  
  $username = stripslashes($username);
  $username = strip_tags($username);
  $username = htmlspecialchars($username, ENT_QUOTES, 'UTF-8');  
  return (preg_match("/^[a-zA-Z0-9\_]{1,20}$/", $username))? $username : false ;  
}

function login_check($mess){
  $mess = trim($mess);
  $mess = htmlspecialchars($mess, ENT_QUOTES, "UTF-8");
  $mess = str_replace(";"," ",$mess);
  $mess = str_replace("$"," ",$mess);
  $mess = str_replace("'"," ",$mess);
  $mess = strip_tags($mess);
  return $mess;
}

//Поиск слов
function strpos_arr($haystack, $needle) {
  $status = true;
  if($needle != ''){
  if(!is_array($needle)) $needle = array($needle);
    foreach ($needle as $value_o) {
      if (strripos(mb_strtolower(trim($haystack), 'UTF-8'), $value_o) !== false) {
        $status = false;
        break;  
      } 
    } 
  }
  return $status;
}

//HASH пароля
function passw($passw) {
  return md5($passw);
}

function GET_DOMEN($url) {
  $parts = @parse_url(trim($url));
  $host = @$parts["host"];
  return $host;
}

function load_online($username, $status = false){
  global $bd;
  
  if(isset($_SERVER['HTTP_USER_AGENT']) &&
    (preg_match('/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i',$_SERVER['HTTP_USER_AGENT'])
    ||
    preg_match('/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i',substr($_SERVER['HTTP_USER_AGENT'],0,4))
  )) {
    $mobusak = 1; 
  }else{
    $mobusak = 2; 
  }

  $bd->query("INSERT INTO `still_online` (`visitor`, `lastvisit`, `usonline`, `mobusak`) 
  VALUES ('".$bd->escape(getRealIP())."', UNIX_TIMESTAMP(), '".$bd->escape($username)."', '".$mobusak."')
  ON DUPLICATE KEY UPDATE 
  `visitor` = '".$bd->escape(getRealIP())."', `lastvisit` = UNIX_TIMESTAMP(), `usonline` = '".$bd->escape($username)."', `mobusak` = '".$mobusak."'");
  
  $uo_count = 1856;
  if($status){
    $result = $bd->query("SELECT COUNT(`usonline`) as `total` FROM `still_online`");
    $data = $result->row;
    $uo_count = $data['total']; 
  }
  
  
  return $uo_count;
  
}

function activ_menu($active, $class = 'active', $no_class = '', $dop_pg = true){
  global $pages;
  return ($pages == $active and $dop_pg) ? $class : $no_class;
}

function users_reyt($reyt){
  
  $input = array();
  
  if ($reyt >= 0 AND $reyt < 10) {$input['css'] = 's_staj'; $input['status'] = 'Стажер'; }
  elseif ($reyt >= 10 AND $reyt < 100) {$input['css'] = 's_rab'; $input['status'] = 'Рабочий'; }
  elseif ($reyt >= 100 AND $reyt < 250) {$input['css'] = 's_brig'; $input['status'] = 'Бригадир'; }
  elseif ($reyt >= 250 AND $reyt < 600) {$input['css'] = 's_mast'; $input['status'] = 'Мастер'; }
  elseif ($reyt >= 600 AND $reyt < 1000) {$input['css'] = 's_pror'; $input['status'] = 'Прораб'; }
  elseif ($reyt >= 1000 AND $reyt < 10000) {$input['css'] = 's_biz'; $input['status'] = 'Бизнесмен'; }
  elseif ($reyt >= 10000 AND $reyt < 50000) {$input['css'] = 's_dep'; $input['status'] = 'Депутат'; }
  elseif ($reyt >= 50000) {$input['css'] = 's_olig'; $input['status'] = 'Олигарх'; }
  else  {$input['css'] = ''; $input['status'] = 'Прохожий'; }
  
  return $input;  
}

//Парсер шаблона
function pars_template($temp, $data, $path, $form = TRUE){
  $input_text = $load_temp_new = '';
  $mass_if = $find = $replace = array();
  $load_temp = file_get_contents($path);
  $input = preg_match("'{".$temp."}(.+?){/".$temp."}'si", $load_temp, $matches);
  
  if($input){
    $input_text = $matches[1];
    
    $input2 = preg_match_all("'{IF (.+?) (==|!=|<=|>=|<|>) (.+?)}(.+?){ENDIF}'si", $input_text, $matches2);
    for($i=0; $i< count($matches2[0]); $i++){
      
      if($matches2[3][$i] == ' ') $matches2[3][$i] = '';
      $mass_if[$matches2[1][$i]][] = array(
        'all_input' => $matches2[0][$i],
        'data' => array($matches2[3][$i], $matches2[2][$i]),
        'out' => $matches2[4][$i]
      );

    }

    if($form){

      foreach($data as $value){
        $load_text = $input_text;
        foreach($value as $key1=>$value_1){
          
          $data_input = (isset($mass_if[mb_strtoupper($key1,"UTF-8")]))? $mass_if[mb_strtoupper($key1,"UTF-8")] : false ;
          if($data_input){
        
        foreach($data_input as $key_if=>$val_if){
          
          $status_z = false;
          
          switch(trim($val_if['data'][1])){
            case '==': if($value_1 == $val_if['data'][0]){ $status_z = true; } break;
            case '!=': if($value_1 != $val_if['data'][0]){ $status_z = true; } break;
            case '>=': if($value_1 >= $val_if['data'][0]){ $status_z = true; } break;
            case '<=': if($value_1 <= $val_if['data'][0]){ $status_z = true; } break;
            case '<' :  if($value_1 < $val_if['data'][0]){ $status_z = true; } break;
            case '>' :  if($value_1 > $val_if['data'][0]){ $status_z = true; } break;
        }
        
        if($status_z){
          $load_text = str_replace($val_if['all_input'],$val_if['out'],$load_text); 
        }else{
          $load_text = str_replace($val_if['all_input'],'',$load_text); 
        }
    
        }
      
      }
          
          $find[] = "'\{".mb_strtoupper($key1,"UTF-8")."\}'i";
          $replace[] = $value_1;
        }
        $load_temp_new .= preg_replace( $find, $replace, $load_text );
        unset($find, $replace, $load_text);
      }

    }else{

      foreach($data as $key=>$value){

        $data_input = (isset($mass_if[mb_strtoupper($key,"UTF-8")]))? $mass_if[mb_strtoupper($key,"UTF-8")] : false ;
        if($data_input){
      
      foreach($data_input as $key_if=>$val_if){
        
        $status_z = false;
          
        switch(trim($val_if['data'][1])){
            case '==': if($value == $val_if['data'][0]){ $status_z = true; } break;
            case '!=': if($value != $val_if['data'][0]){ $status_z = true; } break;
            case '>=': if($value >= $val_if['data'][0]){ $status_z = true; } break;
            case '<=': if($value <= $val_if['data'][0]){ $status_z = true; } break;
            case '<' :  if($value < $val_if['data'][0]){ $status_z = true; } break;
            case '>' :  if($value > $val_if['data'][0]){ $status_z = true; } break;
      }
        
      if($status_z){
        $input_text = str_replace($val_if['all_input'],$val_if['out'],$input_text); 
      }else{
        $input_text = str_replace($val_if['all_input'],'',$input_text); 
      }
    
      }
      
    }
        
        $find[] = "'\{".mb_strtoupper($key,"UTF-8")."\}'i";
        $replace[] = $value;
        
      }
      $load_temp_new = preg_replace( $find, $replace, $input_text );
      unset($find,$replace);
    }
  }

  unset($matches, $mass_if, $matches2, $input_text);

  return $load_temp_new;
}

//Обработка LIKE
function like($text){
  return $text;
}

function smile($mes, $vid = true) {
  $mes = str_ireplace("<br><br>", "<br>", $mes);
  if($vid){
    $mes = preg_replace("':(smile-){1}([0-9]{1,2}):'i", "<img src=\"statica/smiles/\\1\\2.gif\">", $mes); 
  }
  $mes = mb_ereg_replace('\n', '<br />', $mes);
  $mes = preg_replace('#https?://(www\.)?(?!'.$_SERVER['HTTP_HOST'].')[^ ]++#iU', '<span style="color:red;font-size:10px;">—сылка вырезана</span>', $mes);
  return $mes;
}

function smile_mails($mes, $vid = true) {
  $no = array('"',"'","javascript:","script","document.","alert(","cookie");
  $ok = array("","","","","","","");
  $mes = str_replace ($no, $ok, $mes);

  $mes = strip_tags($mes);

  $my_site = $_SERVER['HTTP_HOST']; //Наш домен
  $yes_link = file_get_contents($_SERVER['DOCUMENT_ROOT']."/config/chat_yes_link.php"); //Разрешенные ссылки
  $stop_words = file_get_contents($_SERVER['DOCUMENT_ROOT']."/config/chat_stop_words.php"); //Файл с стоп словами

  $mes = preg_replace("/\[b\](.+)\[\/b\]/Usi","<strong>\\1</strong>",$mes);
  $mes = preg_replace("/\[i\](.+)\[\/i\]/Usi","<em>\\1</em>",$mes);
  $mes = preg_replace("/\[u\](.+)\[\/u\]/Usi","<u>\\1</u>",$mes);
  $mes=preg_replace("/\[quote=(.+)\](.*)\[\/quote\]/Usi", "<div class=\"blok-quote\"><div class=\"title_quote\"><b>\\1</b></div> <div class=\"quote\">\\2</div></div>", $mes);

  $mes = str_replace("\\r\\n"," <br>",$mes);
  $mes = str_replace("\r\n"," <br>",$mes);
  $mes = str_replace("\n"," <br>",$mes);
  $mes = str_replace("\r"," <br>",$mes);

  $mes = str_ireplace("<br><br>", "<br>", $mes);
  
  if($vid){
    $mes = preg_replace("':(smile-){1}([0-9]{1,2}):'i", "<img src=\"//".$my_site."/statica/smiles/\\1\\2.gif\">", $mes);
  }
  
  $needle   = '[/urlsysprof]';

  $pos = strripos($mes, $needle);

  if ($pos === false) {
    $mes = preg_replace("#https?://(www\.)?[^ ]++#iU", "<a href=\"$0\" target=_blank>$0</a>", nl2br($mes));
    $mes = preg_replace('#'.$stop_words.'#i', '<span style="color:red;font-size:10px;">цензура</span>', $mes);
  }else{
    $mes=preg_replace("/\[urlsysprof=(.+)\](.+)\[\/urlsysprof\]/Usi",'<a href="\\2" target="_blank">\\1</a>',$mes);
  }

  return $mes;
}

$arr_let = array( 'года', 'лет', 'лет' );
function getPhrase( $number, $titles ) {
  $cases = array( 2, 0, 1, 1, 1, 2 );
  return $titles[ ( $number % 100 > 4 && $number % 100 < 20 ) ? 2 : $cases[ min( $number % 10, 5 ) ] ];
}

function limpiarez($mensaje){
  $mensaje = htmlspecialchars(trim($mensaje), ENT_QUOTES, 'UTF-8');
  $mensaje = str_replace('>', '&#062;', $mensaje);
  $mensaje = str_replace('<', '&#060;', $mensaje);
  $mensaje = str_replace("'", '&#039;', $mensaje);
  //$mensaje = str_replace("$", "&#036;", $mensaje);
  $mensaje = str_replace('"', "&#034;", $mensaje);
  $mensaje = str_replace('&amp amp ', '&', $mensaje);
  $mensaje = str_replace('&amp;', '&', $mensaje);
  $mensaje = str_replace('&&', '&', $mensaje);
  return $mensaje;
}

//точное округление
function moneyraund ($money, $kol)
{
    if ($money == 0) {
        $money = 0.00;
        return $money;
    } else
    if (strpos($money, '.')) {
        $money = explode('.', $money);
        return $money[0] . '.' . substr($money[1], 0, $kol);
    } else {
        return $money;
    }
}

# функция генерации случайной строки #
function generated_random_string($lenght)
{
    $string = '';
    $chars = 'qwertyuiopasdfghjklzxcvbnm1234567890';
    $count_chars = strlen ($chars);
    for ($i = 0; $i < $lenght; $i++)
    {
        $rand = rand (1, $count_chars);
        $string .= substr ($chars, $rand, 1); //возвращаем строку длиной 1 символ
    }
    return $string;
}
# функция генерации случайной строки #

function date_ost($ost)
{
  $days = floor($ost/86400);
  $hours = floor( ($ost - ($days * 86400)) / 3600);
  $minutes = floor( ($ost - ($days * 86400) - ($hours * 3600)) / 60 );
  $seconds = floor($ost - ($days * 86400) - ($hours * 3600) - ($minutes * 60));

  if($days>0) {
    if(($days>=10)&&($days<=20)) {
      $d="дней";
    }else{
      switch(substr($days, -1, 1)){
        case 1: $d="день"; break;
        case 2: case 3: case 4: $d="дня"; break;
        case 5: case 6: case 7: case 8: case 9: case 0: $d="дней"; break;
      }
    }
  }else{
    $days=""; $d="";
  }

  if($hours>0) {
    if(($hours>=10)&&($hours<=20)) {
      $h="часов";
    }else{
      switch(substr($hours, -1, 1)) {
        case 1: $h="час"; break;
        case 2: case 3: case 4: $h="часа"; break;
        case 5: case 6: case 7: case 8: case 9: case 0: $h="часов"; break;
      }
    }
  }else{
    $hours=""; $h="";
  }

  if($minutes>0) {
    if(($minutes>=10)&&($minutes<=20)) {
      $m="мин.";
    }else{
      switch(substr($minutes, -1, 1)) {
        case 1: $m="мин."; break;
        case 2: case 3: case 4: $m="мин."; break;
        case 5: case 6: case 7: case 8: case 9: case 0: $m="мин."; break;
      }
    }
  }else{
    $minutes=""; $m="";
  }

  if($seconds>0) {
    if(($seconds>=10)&&($seconds<=20)) {
      $s="секунд";
    }else{
      switch(substr($seconds, -1, 1)) {
        case 1: $s="секунда"; break;
        case 2: case 3: case 4: $s="секунды"; break;
        case 5: case 6: case 7: case 8: case 9: case 0: $s="секунд"; break;
      }
    }
  }else{
    $seconds=""; $s="";
  }

  return "<b>$days</b> $d <b>$hours</b> $h <b>$minutes</b> $m";
}


function limitatexto( $texto, $limite ){
  if( mb_strlen($texto,'UTF-8') > $limite ) $texto = mb_substr($texto, 0, $limite, 'UTF-8');
  return $texto;
}

function limpiar($mensaje)
{
$mensaje = htmlentities(stripslashes(trim($mensaje)));
$mensaje = str_replace("'"," ",$mensaje);
$mensaje = str_replace(";"," ",$mensaje);
$mensaje = str_replace("$"," ",$mensaje);
return $mensaje;
}

function limpiarrr($mensaje)
{
  $mensaje = str_replace("'"," ",$mensaje);
  $mensaje = str_replace(";"," ",$mensaje);
  //$mensaje = str_replace("$"," ",$mensaje);
  $mensaje = str_replace("<"," ",$mensaje);
  $mensaje = str_replace(">"," ",$mensaje);
  return $mensaje;
}

function limpiarrrtps($mensaje)
{
  $mensaje = str_replace("'"," ",$mensaje);
  //$mensaje = str_replace(";"," ",$mensaje);
  //$mensaje = str_replace("$"," ",$mensaje);
  $mensaje = str_replace("<"," ",$mensaje);
  $mensaje = str_replace(">"," ",$mensaje);
  return $mensaje;
}

function getBalans($balans, $decimals = 4)
{
  $money = floor($balans*pow(10,$decimals))/pow(10,$decimals);
  $money_cel = intval($money);
  return $money;
}

function getRealIP()
{
  if (isset($_SERVER['HTTP_CF_CONNECTING_IP']))
    return $_SERVER['HTTP_CF_CONNECTING_IP'];

   if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
   {
      $client_ip =
         ( !empty($_SERVER['REMOTE_ADDR']) ) ?
            $_SERVER['REMOTE_ADDR']
            :
            ( ( !empty($_ENV['REMOTE_ADDR']) ) ?
               $_ENV['REMOTE_ADDR']
               :
               "unknown" );
      $entries = preg_split('[, ]', $_SERVER['HTTP_X_FORWARDED_FOR']); // split заменен на preg_split

      reset($entries);
      foreach ($entries as $k => $entry)
      {
         $entry = trim($entry);
         if( preg_match("/^([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+)/", $entry, $ip_list) )
         {
            // http://www.faqs.org/rfcs/rfc1918.html
            $private_ip = array(
                  '/^0\./',
                  '/^127\.0\.0\.1/',
                  '/^192\.168\..*/',
                  '/^172\.((1[6-9])|(2[0-9])|(3[0-1]))\..*/',
                  '/^10\..*/');

            $found_ip = preg_replace($private_ip, $client_ip, $ip_list[1]);

            if($client_ip != $found_ip)
            {
               $client_ip = $found_ip;
               break;
            }
         }
      }
   }
   else
   {
      $client_ip =
         ( !empty($_SERVER['REMOTE_ADDR']) ) ?
            $_SERVER['REMOTE_ADDR']
            :
            ( ( !empty($_ENV['REMOTE_ADDR']) ) ?
               $_ENV['REMOTE_ADDR']
               :
               "unknown" );
   }

   return $client_ip;
}

function sf($str){
  return $bd->escape(strip_tags(htmlspecialchars($str)));
}

//-------------------------------------------------------------------
// Функция определения браузера по данным поля User-Agent
//-------------------------------------------------------------------
function GetUserAgent() {
// Получить переменную окружения
$str=getenv('HTTP_USER_AGENT');
// Попытаться определить известные браузеры по сигнатурам
if (strpos($str,"Avant Browser",0)!==false) {
// return "Avant Browser";
return 1;
}
elseif (strpos($str,"Acoo Browser",0)!==false) {
// return "Acoo Browser";
return 2;
}

elseif (preg_match('/Iron\/([0-9a-z\.]*)/',$str,$pocket)) {
// return "SRWare Iron ".$pocket[1];
return 3;
}
elseif (preg_match("/CoolNovo\/([0-9a-z\.]*)/",$str,$pocket)) {
// return "CoolNovo ".$pocket[1];
return 16;
}

elseif (preg_match("/YaBrowser\/([0-9a-z\.]*)/",$str,$pocket)) {
// return "YaBrowser ".$pocket[1];
return 15;
}
elseif (preg_match("/OPR\/([0-9a-z\.]*)/",$str,$pocket)) {
// return "Google Chrome ".$pocket[1];
return 14;
}

elseif (preg_match("/Chrome\/([0-9a-z\.]*)/",$str,$pocket)) {
// return "Google Chrome ".$pocket[1];
return 4;
}
elseif (preg_match("/(Maxthon|NetCaptor)( [0-9a-z\.]*)?/",$str,$pocket)) {
// return $pocket[1].$pocket[2];
return 5;
}
elseif (strpos($str,"MyIE2",0)!==false) {
// return "MyIE2";
return 6;
}
elseif (preg_match("/(NetFront|K-Meleon|Netscape|Galeon|Epiphany|Konqueror|"."Safari|Opera Mini)\/([0-9a-z\.]*)/",$str,$pocket)) {
// return $pocket[1]." ".$pocket[2];
return 7;
}
elseif (preg_match("/Opera[\/ ]([0-9a-z\.]*)/",$str,$pocket)) {
// return "Opera ".$pocket[1];
return 8;
}
elseif (preg_match("/Orca\/([ 0-9a-z\.]*)/",$str,$pocket)) {
// return "Orca Browser ".$pocket[1];
return 9;
}
elseif (preg_match("/(SeaMonkey|Firefox|GranParadiso|Minefield|"."Shiretoko)\/([0-9a-z\.]*)/",$str,$pocket)) {
// return "Mozilla ".$pocket[1]." ".$pocket[2];
return 10;
}
elseif (preg_match("/rv:([0-9a-z\.]*)/",$str,$pocket) &&
strpos($str,"Mozilla/",0)!==false) {
// return "Mozilla ".$pocket[1];
return 11;
}
elseif (preg_match("/Lynx\/([0-9a-z\.]*)/",$str,$pocket)) {
// return "Lynx ".$pocket[1];
return 12;
}
elseif (preg_match("/MSIE ([0-9a-z\.]*)/",$str,$pocket)) {
// return "Internet Explorer ".$pocket[1];
return 13;
}
elseif (preg_match("/20100101\/([0-9a-z\.]*)/",$str,$pocket)) {
# return "Tor ".$pocket[1];
return 17;
}
elseif (preg_match("/Edge\/([0-9a-z\.]*)/",$str,$pocket)) {
# return "Microsoft Edge ".$pocket[1];
return 18;
}

elseif (preg_match('/android.+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine |fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|meego.+mobile|midp|mmp |netfront|opera m(ob|in)i|palm( os)?|phone |p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo |up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i', $str,$pocket) || preg_match ('/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi |an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan |be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa |cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte |dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8 |ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene |gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit |hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(di|rc|ri)|mi(o8|oa|ts) |mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im |op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox |psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek |r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm |ms |ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc |nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id) |sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v ) |sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m) |tim\-|t\-mo |to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750 |veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80 |81 |83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb |wonu|x700|yas\-|your| zeto|zte\-/i', $str,$pocket)) {
# return "Mob ".$pocket[1];
return 88;
}
else {
// Это какой-то неизвестный браузер
// return "Unknown";
return 99;
}
}

//-------------------------------------------------------------------
// Функция вывода даты в формате сегодня, вчера, N дней назад
//-------------------------------------------------------------------
function give_date($get_date)
{
        $date_dm_now = date("d.m"); # сегодня (d.m)
        if($date_dm_now == date("d.m", $get_date)){$date_vhod = '<font color="green"><b>Сегодня</b><br>в '.date("H:i", $get_date).'</font>';}
    elseif($date_dm_now == date("d.m", $get_date + 86400)){$date_vhod = '<font color="#006699"><b>Вчера</b><br>в '.date("H:i", $get_date).'</font>';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 2)){$date_vhod='2 дня назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 3)){$date_vhod='3 дня назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 4)){$date_vhod='4 дня назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 5)){$date_vhod='5 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 6)){$date_vhod='6 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 7)){$date_vhod='7 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 8)){$date_vhod='8 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 9)){$date_vhod='9 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 10)){$date_vhod='10 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 11)){$date_vhod='11 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 12)){$date_vhod='12 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 13)){$date_vhod='13 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 14)){$date_vhod='14 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 15)){$date_vhod='15 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 16)){$date_vhod='16 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 17)){$date_vhod='17 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 18)){$date_vhod='18 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 19)){$date_vhod='19 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 20)){$date_vhod='20 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 21)){$date_vhod='21 день назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 22)){$date_vhod='22 дня назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 23)){$date_vhod='23 дня назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 24)){$date_vhod='24 дня назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 25)){$date_vhod='25 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 26)){$date_vhod='26 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 27)){$date_vhod='27 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 28)){$date_vhod='28 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 29)){$date_vhod='29 дней назад';}
    elseif($date_dm_now == date("d.m", $get_date + 86400 * 30)){$date_vhod='30 дней назад';}
    else{$date_vhod = date("d.m.Y",$get_date);}
    return $date_vhod;
}
function new_date($ref_date)
{
        $date_dm_now = date("d.m.Y"); # сегодня (d.m)
        if($date_dm_now == date("d.m.Y", $ref_date)){$date_s_ref='0 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400)){$date_s_ref='1 день';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 2)){$date_s_ref='2 дня';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 3)){$date_s_ref='3 дня';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 4)){$date_s_ref='4 дня';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 5)){$date_s_ref='5 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 6)){$date_s_ref='6 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 7)){$date_s_ref='7 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 8)){$date_s_ref='8 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 9)){$date_s_ref='9 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 10)){$date_s_ref='10 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 11)){$date_s_ref='11 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 12)){$date_s_ref='12 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 13)){$date_s_ref='13 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 14)){$date_s_ref='14 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 15)){$date_s_ref='15 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 16)){$date_s_ref='16 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 17)){$date_s_ref='17 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 18)){$date_s_ref='18 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 19)){$date_s_ref='19 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 20)){$date_s_ref='20 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 21)){$date_s_ref='21 день';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 22)){$date_s_ref='22 дня';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 23)){$date_s_ref='23 дня';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 24)){$date_s_ref='24 дня';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 25)){$date_s_ref='25 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 26)){$date_s_ref='26 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 27)){$date_s_ref='27 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 28)){$date_s_ref='28 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 29)){$date_s_ref='29 дней';}
    elseif($date_dm_now == date("d.m.Y", $ref_date + 86400 * 30)){$date_s_ref='30 дней';}
    else{$date_s_ref = date("d.m.Y",$ref_date);}
    return $date_s_ref;
}
//-------------------------------------------------------------------

function decodsocialrep($text){

   $conv = array (
   "%D0%B0", "%D0%B1", "%D0%B2", "%D0%B3", "%D0%B4", "%D0%B5", "%D1%91", "%D0%B6", "%D0%B7",
   "%D0%B8", "%D0%B9", "%D0%BA", "%D0%BB", "%D0%BC", "%D0%BD", "%D0%BE", "%D0%BF", "%D1%80",
   "%D1%81", "%D1%82", "%D1%83", "%D1%84", "%D1%85", "%D1%86", "%D1%87", "%D1%88", "%D1%89",
   "%D1%8A", "%D1%8B", "%D1%8C", "%D1%8D", "%D1%8E", "%D1%8F",
   "%D0%90", "%D0%91", "%D0%92", "%D0%93", "%D0%94", "%D0%95", "%D0%81", "%D0%96", "%D0%97",
   "%D0%98", "%D0%99", "%D0%9A", "%D0%9B", "%D0%9C", "%D0%9D", "%D0%9E", "%D0%9F", "%D0%A0",
   "%D0%A1", "%D0%A2", "%D0%A3", "%D0%A4", "%D0%A5", "%D0%A6", "%D0%A7", "%D0%A8", "%D0%A9",
   "%D0%AA", "%D0%AB", "%D0%AC", "%D0%AD", "%D0%AE", "%D0%AF"
   );

   $rus = array (
   "а", "б", "в", "г", "д", "е", "ё", "ж", "з",
   "и", "й", "к", "л", "м", "н", "о", "п", "р",
   "с", "т", "у", "ф", "х", "ц", "ч", "ш", "щ",
   "ъ", "ы", "ь", "э", "ю", "я",
   "А", "Б", "В", "Г", "Д", "Е", "Ё", "Ж", "З",
   "И", "Й", "К", "Л", "М", "Н", "О", "П", "Р",
   "С", "Т", "У", "Ф", "Х", "Ц", "Ч", "Ш", "Щ",
   "Ъ", "Ы", "Ь", "Э", "Ю", "Я"
   );

   $input = str_replace( $rus, $conv, $text);

   return $input;
}

//Подгрузка аватар
function ava_img($username){
  global $setup_web;
  $img_patch = $setup_web['avatar-url'];
  $patch = $_SERVER['DOCUMENT_ROOT'].'/ava/';
  $dir = mb_strtolower(mb_substr($username, 0, 1)).'/';
  if ($username == 'Гость') {
    $src = $img_patch.'no_avatar.svg';
  }
  elseif ($username == 'Система'){
    $src = $img_patch.'no_avatar.svg';
  }else{
    $name_files = '';
    if (is_dir($patch.$dir)) {
      if ($open_dir = opendir($patch.$dir)) {
        while (false !== ($filename = readdir($open_dir))) {
          if(preg_match('/^'.mb_strtolower($username, 'UTF-8').'\.(gif|jpg|jpeg|png)/', $filename)){
           $name_files = $filename;
          }
        }
      }
    }
    if($name_files != ''){
      $src = $img_patch.$dir.$name_files;
    }else{
      $src = $img_patch.'no_avatar.svg';
    }
  }
  return $src;
}

function pars_gclid($text){
  return preg_replace("'(gclid=)([a-zA-Z0-9_-]{1,32})([&#]*)'i",'$1<b class="new-gclid">$2</b>$3',$text); 
}

function number_format_n($val, $decimals, $string = false){      
  
  $money = floor($val*pow(10,$decimals))/pow(10,$decimals);
  $money_cel = intval($money);
  
  $rezult = (!$string)? $money : '<b>'.$money_cel.'</b> руб. <b>'.(floor(($money-$money_cel)*pow(10,2))).'</b> коп.' ;
  
  return $rezult; 
}

function getInfoContest($db, $contestType)
{
  return $db->query("SELECT * FROM `still_competition` WHERE `end_date` > UNIX_TIMESTAMP() and `start_date` <  UNIX_TIMESTAMP() and `vid` = {$contestType} AND `status_bonus` = 0 ORDER BY `id` DESC LIMIT 1")->row;
}

function convert_date($date){
  $time_data = (time()-$date)/86400;
  if(date("d.m.Y",time()) == date("d.m.Y", $date)){ $time_text = '<span style="color:green;">Сегодня в '.date("H:i",$date).'</span>';}
  elseif(date("d.m.Y",time()-86400) == date("d.m.Y", $date)){ $time_text = '<span style="color:#cd6c01;">Вчера в '.date("H:i",$date).'</span>';}
  else{ $time_text = date("d.m.Y в H:i",$date);}
  return $time_text;
}

function zamena_temp($text, $users, $fio_users, $support, $fio_support){
  
  if($users == 'Гость') $users = '';
  
  $dop_username = $users;
  $dop_modername = $support;
  
  $text = str_replace("{USERS}", $users, $text);
  $text = str_replace("{FIO_USERS}", $fio_users, $text);
  $text = str_replace("{SUPPORT}", $support, $text);
  $text = str_replace("{FIO_SUPPORT}", $fio_support, $text);
  
  if($fio_users != '') $dop_username = $fio_users;  
  if($fio_support != '') $dop_modername = $fio_support; 

  $text = str_replace("{DOP_USERNAME}", $dop_username, $text);
  $text = str_replace("{DOP_SUPPORT}", $dop_modername, $text);
  
  return $text;
}

function sql_ajax_text($text)
{
  $text = stripslashes($text);
  $text = htmlspecialchars($text, ENT_QUOTES, 'WINDOWS-1251');
  $text = str_replace("'"," ",$text);
  $text = str_replace("$"," ",$text);
  $text = str_replace("<"," ",$text);
  $text = str_replace(">"," ",$text);
  return $text;
}

function form_field_toggle($name, $value)
{
  return "<select class='input' name='$name'>
    <option ".(($value === '0') ? 'selected' : '')." value='0'>Отключено</option>
    <option ".(($value === '1') ? 'selected' : '')." value='1'>Включено</option>
  </select>";
}

function moneyformat($num, $scale = 2)
{
    if(is_numeric($num) && bccomp($num, '9999999999.9999') <= 0)
        return number_format($num, $scale, '.', '');
    return '0';
}

function anypay_payment($merch_tran_id, $summa, $options = [])
{
  global $setup_payment;
  $s = 'https://anypay.io/merchant';
  $a = array_merge([
      'merchant_id' => $setup_payment['anypay_id'],
      'pay_id' => $merch_tran_id,
      'amount' => $summa,
      'currency' => 'RUB'
  ], $options);
  $a['sign'] = md5(implode(':', [ $a['currency'], $a['amount'], $setup_payment['anypay_secret_key'], $a['merchant_id'], $a['pay_id'] ]));
  $p = http_build_query($a);
  $url = $s.'?'.$p;
  return $url;
}

function get_diff_days($date1, $date2) // получить разницу дней между датами
{
    $dt1 = new DateTime($date1);
    $dt2 = new DateTime($date2);
    $days = $dt1->diff($dt2)->days;
    return $days;
}

function get_diff_sec($date1, $date2) // получить разницу секунд между датами
{
    return strtotime($date1) - strtotime($date2);
}

// получает цену за текстовое объявление
function get_price_txt($txt)
{
  global $money_advertise;
  return $money_advertise['text'] + ($txt['color'] * $money_advertise['text_bold']);
}

function form_captcha()
{
  global $setup_other;
  if (!$setup_other['recaptcha_status']) return '';
  return '<div class="g-recaptcha" data-sitekey="'.$setup_other['recaptcha_v2_site_key'].'"></div>';
}

function check_captcha()
{
  global $setup_other;
  if (!$setup_other['recaptcha_status']) return true;
  if (!isset($_POST['g-recaptcha-response'])) return false;
  $response = $_POST['g-recaptcha-response'];
  $url = 'https://www.google.com/recaptcha/api/siteverify';
  $client = new \GuzzleHttp\Client();
  if (DEBUG)
    writeLog('send post with data: '.json_encode([
        'secret' => $setup_other['recaptcha_v2_secret_key'],
        'response' => $response
    ]), 'captcha.log');
  $res = $client->request('POST', $url, [
      'form_params' => [
          'secret' => $setup_other['recaptcha_v2_secret_key'],
          'response' => $response
      ]
  ]);
  $res = json_decode($res->getBody()->getContents(), true);
  if (DEBUG)
    writeLog('answer: '.json_encode($res), 'captcha.log');
  return $res['success'];
}